
from gurobipy import *

# Create a new model
m = Model("Tool_Production")

# Define the decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Drills")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Saws")

# Set the objective function to maximize profit
m.setObjective(35*x + 100*y, GRB.MAXIMIZE)

# Add constraints for milling and CNG machines
m.addConstr(20*x + 30*y <= 800, name="Milling_Machine_Constraint")
m.addConstr(70*x + 90*y <= 800, name="CNG_Machine_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Drills: {x.x}")
    print(f"Saws: {y.x}")
    print(f"Maximum Profit: ${m.objVal:.2f}")
else:
    print("No optimal solution found")
