
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x = model.addVar(lb=0, name="drills")
    y = model.addVar(lb=0, name="saws")

    # Define the objective function
    model.setObjective(35 * x + 100 * y, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(20 * x + 30 * y <= 800, name="milling_machine")
    model.addConstr(70 * x + 90 * y <= 800, name="CNG_machine")

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Drills to produce: {x.varValue}")
        print(f"Saws to produce: {y.varValue}")
        print(f"Maximum profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
