
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create decision variables
x_energy = m.addVar(lb=0, name="x_energy")
x_telecom = m.addVar(lb=0, name="x_telecom")
x_utilities = m.addVar(lb=0, name="x_utilities")
x_healthcare = m.addVar(lb=0, name="x_healthcare")

# Set objective function
m.setObjective(0.05 * x_energy + 0.08 * x_telecom + 0.03 * x_utilities + 0.09 * x_healthcare, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_energy + x_telecom + x_utilities + x_healthcare == 300000, "Total_Investment")
m.addConstr(x_healthcare <= x_energy, "Healthcare_Limit")
m.addConstr(x_telecom <= x_utilities, "Telecom_Limit")
m.addConstr(x_healthcare <= 0.33 * 300000, "Healthcare_Percentage_Limit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Energy: ${x_energy.x:.2f}")
    print(f"Invest in Telecom: ${x_telecom.x:.2f}")
    print(f"Invest in Utilities: ${x_utilities.x:.2f}")
    print(f"Invest in Healthcare: ${x_healthcare.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

