
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define the decision variables
E = m.addVar(lb=0, name="Energy")
T = m.addVar(lb=0, name="Telecom")
U = m.addVar(lb=0, name="Utilities")
H = m.addVar(lb=0, name="Health_Care")

# Define the constraints
m.addConstr(E + T + U + H <= 300000, "Total_Investment")
m.addConstr(H <= E, "Health_Care_VS_Energy")
m.addConstr(T <= U, "Telecom_VS_Utilities")
m.addConstr(H <= 0.33 * (E + T + U + H), "Max_Health_Care_Percentage")

# Define the objective function
m.setObjective(0.05*E + 0.08*T + 0.03*U + 0.09*H, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Energy: {E.x}")
    print(f"Telecom: {T.x}")
    print(f"Utilities: {U.x}")
    print(f"Health Care: {H.x}")
    print(f"Total Return: {m.objVal}")
else:
    print("No optimal solution found")
