
import gurobi

def solve_investment_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    E = model.addVar(lb=0, name="Energy")
    T = model.addVar(lb=0, name="Telecom")
    U = model.addVar(lb=0, name="Utilities")
    H = model.addVar(lb=0, name="Health Care")

    # Objective function: maximize return on investment
    model.setObjective(0.05 * E + 0.08 * T + 0.03 * U + 0.09 * H, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(H <= E, name="Health Care <= Energy")
    model.addConstr(T <= U, name="Telecom <= Utilities")
    model.addConstr(H <= 0.33 * 300000, name="Health Care <= 33% of total")
    model.addConstr(E + T + U + H <= 300000, name="Total investment <= $300,000")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Energy: ${E.varValue:.2f}")
        print(f"Telecom: ${T.varValue:.2f}")
        print(f"Utilities: ${U.varValue:.2f}")
        print(f"Health Care: ${H.varValue:.2f}")
        print(f"Return on investment: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
