
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("AquariumFeed")

# Create decision variables
x = model.addVar(vtype=GRB.CONTINUOUS, name="sardines")
y = model.addVar(vtype=GRB.CONTINUOUS, name="tuna")

# Set objective function
model.setObjective(15*x + 18*y, GRB.MINIMIZE)

# Add constraints
model.addConstr(4*x + 6*y >= 800, "Fat")
model.addConstr(12*x + 10*y >= 1200, "EFA")
model.addConstr(10*x + 7*y >= 700, "Protein")

# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Number of sardine packets: {x.x:.2f}")
    print(f"Number of tuna packets: {y.x:.2f}")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

