
from gurobipy import *

# Create a new model
m = Model("Aquarium_Feeding")

# Define the decision variables
x_s = m.addVar(vtype=GRB.CONTINUOUS, name="sardines")
x_t = m.addVar(vtype=GRB.CONTINUOUS, name="tuna")

# Set the objective function
m.setObjective(15*x_s + 18*x_t, GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x_s + 6*x_t >= 800, "fat")
m.addConstr(12*x_s + 10*x_t >= 1200, "essential_fatty_acids")
m.addConstr(10*x_s + 7*x_t >= 700, "protein")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Sardines: {x_s.x}")
    print(f"Tuna: {x_t.x}")
    print(f"Total Cost: {m.objVal}")
else:
    print("No optimal solution found")
