
import gurobi

def solve_aquarium_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x = model.addVar(name="sardines", lb=0, vtype=gurobi.GRB.INTEGER)  # Number of packets of sardines
    y = model.addVar(name="tuna", lb=0, vtype=gurobi.GRB.INTEGER)    # Number of packets of tuna

    # Objective: Minimize the total cost
    model.setObjective(15 * x + 18 * y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x + 6 * y >= 800, name="fat_requirement")  # Fat requirement
    model.addConstr(12 * x + 10 * y >= 1200, name="fatty_acids_requirement")  # Essential fatty acids requirement
    model.addConstr(10 * x + 7 * y >= 700, name="protein_requirement")  # Protein requirement

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Minimum cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_aquarium_problem()
