
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Optimization")

# Create variables
g = m.addVar(lb=0, name="gold")
d = m.addVar(lb=0, name="diamond")
r = m.addVar(lb=0, name="ruby")
s = m.addVar(lb=0, name="sapphire")

# Set objective function
m.setObjective(0.03*g + 0.05*d + 0.06*r + 0.10*s, GRB.MAXIMIZE)

# Add constraints
m.addConstr(g + d + r + s <= 1000000, "Total_Investment")
m.addConstr(s <= g, "Sapphire_Limit")
m.addConstr(d <= r, "Diamond_Limit")
m.addConstr(s <= 0.4 * 1000000, "Max_Sapphire")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal return: ${m.objVal:.2f}")
    print(f"Invest in Gold: ${g.x:.2f}")
    print(f"Invest in Diamond: ${d.x:.2f}")
    print(f"Invest in Ruby: ${r.x:.2f}")
    print(f"Invest in Sapphire: ${s.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

