
from gurobipy import *

# Create a model
m = Model("Investment_Optimization")

# Define decision variables
x_g = m.addVar(name="gold")
x_d = m.addVar(name="diamond")
x_r = m.addVar(name="ruby")
x_s = m.addVar(name="sapphire")

# Objective function: Maximize return
m.setObjective(0.03*x_g + 0.05*x_d + 0.06*x_r + 0.10*x_s, GRB.MAXIMIZE)

# Constraints
m.addConstr(x_g + x_d + x_r + x_s <= 1000000, name="budget")
m.addConstr(x_s <= x_g, name="sapphire_vs_gold")
m.addConstr(x_d <= x_r, name="diamond_vs_ruby")
m.addConstr(x_s <= 400000, name="max_sapphire")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Gold: {x_g.x}")
    print(f"Diamond: {x_d.x}")
    print(f"Ruby: {x_r.x}")
    print(f"Sapphire: {x_s.x}")
    print(f"Total Return: {m.objVal}")
else:
    print("No optimal solution found")
