
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    G = model.addVar(lb=0, name="Gold")
    D = model.addVar(lb=0, name="Diamond")
    R = model.addVar(lb=0, name="Ruby")
    S = model.addVar(lb=0, name="Sapphire")

    # Objective function: Maximize return on investment
    model.setObjective(0.03*G + 0.05*D + 0.06*R + 0.10*S, gurobi.GRB.MAXIMIZE)

    # Total investment constraint
    model.addConstr(G + D + R + S <= 1000000, name="Total_Investment")

    # Sapphire vs. Gold constraint
    model.addConstr(S <= G, name="Sapphire_vs_Gold")

    # Diamond vs. Ruby constraint
    model.addConstr(D <= R, name="Diamond_vs_Ruby")

    # Sapphire industry limit
    model.addConstr(S <= 400000, name="Sapphire_Limit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal investment strategy:")
        print(f"Gold: ${G.varValue}")
        print(f"Diamond: ${D.varValue}")
        print(f"Ruby: ${R.varValue}")
        print(f"Sapphire: ${S.varValue}")
        print(f"Max Return: ${model.objVal}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
