
import gurobipy as gp

# Create a new model
m = gp.Model("puzzle_optimization")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="x") # easy puzzles
y = m.addVar(vtype=gp.GRB.INTEGER, name="y") # hard puzzles

# Set objective function
m.setObjective(5*x + 8*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(x >= 3, "easy_min")
m.addConstr(y >= 1, "hard_min")
m.addConstr(x <= 10, "easy_max")
m.addConstr(y <= 5, "hard_max")
m.addConstr(x + y <= 10, "total_max")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Solve {x.x} easy puzzles and {y.x} hard puzzles")
    print(f"Total points: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

