
from gurobipy import *

# Create a model
m = Model("Puzzle Optimization")

# Define the decision variables
x_e = m.addVar(name='easy_puzzles', vtype=GRB.INTEGER, lb=0)
x_h = m.addVar(name='hard_puzzles', vtype=GRB.INTEGER, lb=0)

# Set the objective function
m.setObjective(5*x_e + 8*x_h, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_e >= 3, name='at_least_3_easy')
m.addConstr(x_h >= 1, name='at_least_1_hard')
m.addConstr(x_e <= 10, name='at_most_10_easy')
m.addConstr(x_h <= 5, name='at_most_5_hard')
m.addConstr(x_e + x_h <= 10, name='total_puzzles_limit')

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Easy puzzles: {x_e.x}")
    print(f"Hard puzzles: {x_h.x}")
    print(f"Total points: {5*x_e.x + 8*x_h.x}")
else:
    print("No optimal solution found")
