
import gurobi

def solve_puzzle_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables with correct bounds
    E = model.addVar(lb=3, ub=10, name="Easy_Puzzles")  # At least 3, at most 10
    H = model.addVar(lb=1, ub=5, name="Hard_Puzzles")   # At least 1, at most 5

    # Objective function: Maximize 5E + 8H
    model.setObjective(5 * E + 8 * H, gurobi.GRB.MAXIMIZE)

    # Additional constraint: E + H <= 10
    model.addConstr(E + H <= 10, name="Total_Max")

    # Integrate new constraints
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Easy Puzzles = {E.varValue}, Hard Puzzles = {H.varValue}")
    else:
        print("No optimal solution found")

solve_puzzle_problem()
