
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="standing_tables") # Allowing fractional tables for now
y = m.addVar(vtype=GRB.CONTINUOUS, name="dining_tables")

# Set objective
m.setObjective(45*x + 95*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 4*y <= 6000, "parts_production")
m.addConstr(2.5*x + y <= 3000, "assembly")
m.addConstr(2*x + 1.5*y <= 4500, "polishing")
m.addConstr(x >= 0, "standing_tables_non_negative")  # Explicit non-negativity constraints
m.addConstr(y >= 0, "dining_tables_non_negative")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal number of standing tables: {x.x}")
    print(f"Optimal number of dining tables: {y.x}")
    print(f"Optimal profit: ${m.objVal}")

    # Round down to get integer solutions if needed
    print("\nInteger Solution (rounded down):")
    print(f"Standing tables: {int(x.x)}")
    print(f"Dining tables: {int(y.x)}")
    print(f"Profit (rounded down solution): ${45*int(x.x) + 95*int(y.x)}")

