
from gurobipy import *

# Create a model
m = Model("Furniture_Maker_Profit")

# Define decision variables
S = m.addVar(vtype=GRB.CONTINUOUS, name="Standing_Tables")
D = m.addVar(vtype=GRB.CONTINUOUS, name="Dining_Tables")

# Objective function: Maximize profit
m.setObjective(45*S + 95*D, GRB.MAXIMIZE)

# Constraints
m.addConstr(2*S + 4*D <= 6000, "Parts_Production")
m.addConstr(2.5*S + D <= 3000, "Assembly")
m.addConstr(2*S + 1.5*D <= 4500, "Polishing")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Standing Tables: {S.x}")
    print(f"Dining Tables: {D.x}")
    print(f"Total Profit: ${45*S.x + 95*D.x:.2f}")
else:
    print("No optimal solution found")
