
import gurobi

def solve_table_production_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the decision variables
    x1 = model.addVar(name="standing_tables", lb=0, ub=None, obj=45)
    x2 = model.addVar(name="dining_tables", lb=0, ub=None, obj=95)

    # Define the constraints
    model.addConstr(2 * x1 + 4 * x2 <= 6000, name="parts_production")
    model.addConstr(2.5 * x1 + x2 <= 3000, name="assembly")
    model.addConstr(2 * x1 + 1.5 * x2 <= 4500, name="polishing")

    # Set the objective function
    model.setObjective(x1.obj * x1 + x2.obj * x2, gurobi.GRB.MAXIMIZE)

    # Optimize the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Standing tables: {x1.x}")
        print(f"Dining tables: {x2.x}")
        print(f"Total profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_table_production_problem()
