
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("wood_shop")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="canoes")  # Canoes
y = m.addVar(vtype=GRB.CONTINUOUS, name="paddles") # Paddles

# Set objective function
m.setObjective(500*x + 75*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1*x + 0.5*y <= 80, "cutting")
m.addConstr(5*x + 1*y <= 100, "woodworking")
m.addConstr(2*x + 0.75*y <= 70, "sanding")
m.addConstr(x >= 0, "canoes_non_neg")
m.addConstr(y >= 0, "paddles_non_neg")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Canoes to produce: {x.x:.2f}")
    print(f"Paddles to produce: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

