
from gurobipy import *

# Create a model
m = Model("Wood_Shop_Optimization")

# Define decision variables
c = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="canoes")
p = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="paddles")

# Objective function: Maximize profit
m.setObjective(500*c + 75*p, GRB.MAXIMIZE)

# Constraints
m.addConstr(c + 0.5*p <= 80, "cutting_time")
m.addConstr(5*c + p <= 100, "woodworking_time")
m.addConstr(2*c + 0.75*p <= 70, "sanding_time")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Canoes = {c.x}, Paddles = {p.x}")
    print(f"Maximum Profit: ${500*c.x + 75*p.x:.2f}")
else:
    print("No optimal solution found")
