
import gurobi as gp

# Create a new model
model = gp.Model("Canoes_and_Paddles")

# Define the decision variables
C = model.addVar(name="Canoes", lb=0, vtype=gp.GRB.CONTINUOUS)
P = model.addVar(name="Paddles", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(500*C + 75*P, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(1*C + 0.5*P <= 80, name="Cutting_Time")
model.addConstr(5*C + 1*P <= 100, name="Woodworking_Time")
model.addConstr(2*C + 0.75*P <= 70, name="Sanding_Time")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Number of canoes: {C.varValue}, Number of paddles: {P.varValue}")
    print(f"Maximum profit: ${500*C.varValue + 75*P.varValue:.2f}")
else:
    print("No optimal solution found.")
