
from gurobipy import Model, GRB

# Create a new model
m = Model("Cruise Ship Profit")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="single_rooms")  # Number of single rooms
y = m.addVar(vtype=GRB.INTEGER, name="couple_rooms")  # Number of couple rooms

# Set objective function
m.setObjective(200*x + 1200*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 800, "total_rooms")
m.addConstr(x >= 125, "min_single_rooms")
m.addConstr(2*x <= 2*y, "couple_preference")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Single Rooms (x): {x.x}")
    print(f"Number of Couple Rooms (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution found.")
else:
    print(f"Optimization terminated with status: {m.status}")

