
from gurobipy import *

# Create a new model
m = Model("cruise_ship_profit")

# Define variables
S = m.addVar(vtype=GRB.INTEGER, name="single_rooms")
C = m.addVar(vtype=GRB.INTEGER, name="couple_rooms")

# Define the objective function
m.setObjective(200*S + 1200*C, GRB.MAXIMIZE)

# Add constraints
m.addConstr(S + C <= 800, "total_rooms")
m.addConstr(S >= 125, "min_single_rooms")
m.addConstr(C >= S, "couple_vs_single")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Maximum Profit:", m.objVal)
    print("Single Rooms:", S.x)
    print("Couple Rooms:", C.x)
else:
    print("Model is infeasible")
