
import gurobipy as gp

# Create a new model
m = gp.Model("CruiseShipProfitMaximization")

# Define variables
S = m.addVar(name="SingleRooms", lb=0, vtype=gp.GRB.INTEGER)
C = m.addVar(name="CoupleRooms", lb=0, vtype=gp.GRB.INTEGER)

# Objective: Maximize profit
m.setObjective(200 * S + 1200 * C, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(S + C <= 800, name="TotalRooms")
m.addConstr(S >= 125, name="MinSingleRooms")
m.addConstr(C >= 2 * S, name="CouplePreference")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution: Single Rooms = {S.varValue}, Couple Rooms = {C.varValue}")
    print(f"Maximum Profit: ${200 * S.varValue + 1200 * C.varValue}")
else:
    print("No optimal solution found")
