
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Hedge_Fund_Investment")

# Create variables
x1 = m.addVar(lb=0, name="Stocks")
x2 = m.addVar(lb=0, name="Options")
x3 = m.addVar(lb=0, name="Security_Swaps")
x4 = m.addVar(lb=0, name="Futures")

# Set objective function
m.setObjective(0.11 * x1 + 0.30 * x2 + 0.05 * x3 + 0.15 * x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 + x3 + x4 == 3.2, "Total_Investment")
m.addConstr(x4 <= x1, "Futures_vs_Stocks")
m.addConstr(x4 <= 0.35 * (x1 + x2 + x3 + x4), "Futures_Percentage")
m.addConstr(x2 <= x3, "Options_vs_Swaps")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Invest in Stocks: {x1.x}")
    print(f"Invest in Options: {x2.x}")
    print(f"Invest in Security Swaps: {x3.x}")
    print(f"Invest in Futures: {x4.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

