
import gurobi

def hedge_fund_optimization():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    S = model.addVar(name="stocks", lb=0)
    O = model.addVar(name="options", lb=0)
    SS = model.addVar(name="security_swaps", lb=0)
    F = model.addVar(name="futures", lb=0)

    # Objective function
    model.setObjective(0.11 * S + 0.30 * O + 0.05 * SS + 0.15 * F, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(S + O + SS + F == 3200000, name="budget")

    # Constraint 1: F <= S
    model.addConstr(F <= S, name="futures_stocks")

    # Constraint 2: F <= 0.35 * (S + O + SS + F)
    model.addConstr(F <= 0.35 * (S + O + SS + F), name="futures_percentage")

    # Constraint 3: O <= SS
    model.addConstr(O <= SS, name="options_swaps")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Stocks: {S.varValue}")
        print(f"Options: {O.varValue}")
        print(f"Security Swaps: {SS.varValue}")
        print(f"Futures: {F.varValue}")
        print(f"Max Return: {model.objVal}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    hedge_fund_optimization()
