
import gurobipy as gp

# Create a new model
model = gp.Model("Adrian's Diet")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bagels")
y = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="burgers")

# Set objective function
model.setObjective(4.5 * x + 12 * y, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(250 * x + 800 * y >= 2500, "calorie_constraint")
model.addConstr(15 * x + 23.5 * y >= 500, "fat_constraint")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Cost: ${model.objVal:.2f}")
    print(f"Number of Bagels: {x.x:.2f}")
    print(f"Number of Burgers: {y.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

