
from gurobipy import *

# Create a new model
m = Model("Adrian_Diet")

# Define variables
bagels = m.addVar(vtype=GRB.CONTINUOUS, name="bagels")
burgers = m.addVar(vtype=GRB.CONTINUOUS, name="burgers")

# Set the objective function
m.setObjective(4.5*bagels + 12*burgers, GRB.MINIMIZE)

# Add constraints
m.addConstr(250*bagels + 800*burgers >= 2500, "calories")
m.addConstr(15*bagels + 23.5*burgers >= 500, "fat")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bagels: {bagels.x}")
    print(f"Burgers: {burgers.x}")
    print(f"Total cost: ${4.5*bagels.x + 12*burgers.x:.2f}")
else:
    print("No optimal solution found")
