
import gurobi

def solve_adrian_diet_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(name="bagels", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    R = model.addVar(name="burgers", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: minimize cost
    model.setObjective(4.5 * B + 12 * R, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(250 * B + 800 * R >= 2500, name="calories")
    model.addConstr(15 * B + 23.5 * R >= 500, name="fat")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objVal:.2f}")
        print(f"Bagels: {B.varValue:.2f}")
        print(f"Burgers: {R.varValue:.2f}")
    else:
        print("No optimal solution found.")

if __name__ == "__main__":
    solve_adrian_diet_problem()
