
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_profit")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="bookcases") # Allowing fractional bookcases/desks for simplicity.  Could be changed to GRB.INTEGER
y = m.addVar(vtype=GRB.CONTINUOUS, name="computer_desks")

# Set objective
m.setObjective(500*x + 80*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x + 5*y <= 1000, "space")
m.addConstr(y >= 0.65*(x + y), "desk_proportion")
m.addConstr(1200*x + 200*y <= 22000, "capital")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal:.2f}")
    print(f"Number of Bookcases: {x.x:.2f}")
    print(f"Number of Computer Desks: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

