
from gurobipy import *

# Create a new model
m = Model("Furniture_Optimization")

# Define the decision variables
x1 = m.addVar(vtype=GRB.INTEGER, name="bookcases")
x2 = m.addVar(vtype=GRB.INTEGER, name="computer_desks")

# Set the objective function to maximize profit
m.setObjective(500*x1 + 80*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 5*x2 <= 1000, "space_constraint")
m.addConstr(-0.65*x1 + 0.35*x2 >= 0, "computer_desks_percentage_constraint")
m.addConstr(1200*x1 + 200*x2 <= 22000, "capital_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Bookcases: {x1.x}")
    print(f"Computer Desks: {x2.x}")
    print(f"Total Profit: ${500*x1.x + 80*x2.x}")
else:
    print("No optimal solution found")
