
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(name="bookcases", lb=0, vtype=gurobi.GRB.INTEGER)
    D = model.addVar(name="desks", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize profit
    model.setObjective(500 * B + 80 * D, gurobi.GRB.MAXIMIZE)

    # Space constraint
    model.addConstr(12 * B + 5 * D <= 1000, name="space_constraint")

    # Product mix constraint
    model.addConstr(D >= (13/7) * B, name="product_mix_constraint")

    # Capital constraint
    model.addConstr(1200 * B + 200 * D <= 22000, name="capital_constraint")

    # Solve the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Bookcases: {B.varValue}, Desks: {D.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
