
import gurobipy as gp
from gurobipy import GRB

# Create a new model
model = gp.Model("Vaccine_Investment")

# Create decision variables
M = model.addVar(lb=0, name="M")
P = model.addVar(lb=0, name="P")

# Set objective function
model.setObjective(0.09 * M + 0.12 * P, GRB.MAXIMIZE)

# Add constraints
model.addConstr(M + P <= 100000, "Total_Investment")
model.addConstr(M >= 3 * P, "Investment_Ratio")
model.addConstr(M <= 80000, "Max_Investment_M")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal investment in company M: ${M.x:.2f}")
    print(f"Optimal investment in company P: ${P.x:.2f}")
    print(f"Maximum earnings: ${model.objVal:.2f}")
else:
    print("No solution found.")

