
from gurobipy import *

# Create a new model
m = Model("Vaccine_Investment")

# Define the decision variables
M = m.addVar(lb=0, name="Investment_in_M")
P = m.addVar(lb=0, name="Investment_in_P")

# Define the objective function: Maximize earnings
m.setObjective(0.09*M + 0.12*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(M + P <= 100000, name="Total_Investment")
m.addConstr(M >= 3*P, name="Minimum_M_to_P_Ratio")
m.addConstr(M <= 80000, name="Maximum_Investment_in_M")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Investment in Company M: ${M.x:.2f}")
    print(f"Optimal Investment in Company P: ${P.x:.2f}")
    print(f"Maximum Earnings: ${m.objVal:.2f}")
else:
    print("Model is infeasible")
