
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_M = model.addVar(lb=0, name="Investment_M")
    x_P = model.addVar(lb=0, name="Investment_P")

    # Objective function: Maximize earnings
    model.setObjective(0.09 * x_M + 0.12 * x_P, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_M + x_P <= 100000, name="Total_Investment")
    model.addConstr(x_M >= 3 * x_P, name="Investment_Ratio")
    model.addConstr(x_M <= 80000, name="Company_M_Limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in M: ${x_M.x:.2f}")
        print(f"Optimal investment in P: ${x_P.x:.2f}")
        print(f"Max earnings: ${0.09 * x_M.x + 0.12 * x_P.x:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
