
import gurobipy as gp

# Create a new model
m = gp.Model("soup_kitchen")

# Create variables
x = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="individual_servings") # Integer number of individual servings
y = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="family_servings") # Integer number of family servings


# Set objective function
m.setObjective(3*x + 10*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(250*x + 1200*y <= 50000, "soup_availability")
m.addConstr(x >= 3*y, "individual_vs_family")
m.addConstr(y >= 10, "min_family")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of individual servings (x): {x.x}")
    print(f"Number of family servings (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

