
from gurobipy import *

# Create a new model
m = Model("Soup_Kitchen_Optimization")

# Define variables
x = m.addVar(name="individual_servings", vtype=GRB.INTEGER)
y = m.addVar(name="family_servings", vtype=GRB.INTEGER)

# Set objective function: Maximize profit
m.setObjective(3*x + 10*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(250*x + 1200*y <= 50000, name="total_volume")
m.addConstr(x >= 3*y, name="individual_servings_minimum")
m.addConstr(y >= 10, name="family_servings_minimum")
m.addConstr(x >= 0, name="non_negative_individual")
m.addConstr(y >= 0, name="non_negative_family")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal individual servings: {x.x}")
    print(f"Optimal family servings: {y.x}")
    print(f"Max Profit: {m.ObjVal}")
else:
    print("No optimal solution found")
