
import gurobipy as gp

# Create a new model
m = gp.Model("soup_kitchen")

# Decision variables
x = m.addVar(name="individual_servings", lb=0, vtype=gp.GRB.INTEGER)
y = m.addVar(name="family_servings", lb=0, vtype=gp.GRB.INTEGER)

# Objective function: Maximize profit
m.setObjective(3*x + 10*y, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(250*x + 1200*y <= 50000, name="soup_limit")
m.addConstr(x >= 3*y, name="individual_vs_family")
m.addConstr(y >= 10, name="min_family_servings")

# Solve the model
m.solve()

# Output solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Individual servings: {x.varValue}, Family servings: {y.varValue}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found.")
