
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("supplement_problem")

# Create variables
x = m.addVar(lb=0, name="alpha_scoops")  # Number of scoops of Alpha
y = m.addVar(lb=0, name="beta_scoops")  # Number of scoops of Beta

# Set objective function: Minimize cost
m.setObjective(1*x + 2*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x + 10*y >= 50, "iron_req")  # Iron requirement
m.addConstr(20*x + 3*y >= 40, "biotin_req") # Biotin requirement

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Alpha scoops: {x.x:.2f}")
    print(f"Beta scoops: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

