
from gurobipy import *

# Create a new model
m = Model("Jane_Supplement")

# Define variables
x_A = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Alpha_Scoops")
x_B = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Beta_Scoops")

# Set the objective function
m.setObjective(1*x_A + 2*x_B, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x_A + 10*x_B >= 50, "Iron_Requirement")
m.addConstr(20*x_A + 3*x_B >= 40, "Biotin_Requirement")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Alpha scoops: {x_A.x}")
    print(f"Beta scoops: {x_B.x}")
    print(f"Total cost: ${1*x_A.x + 2*x_B.x:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible.")
