
import gurobi

def solve_supplement_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    x = model.addVar(name="Alpha", lb=0, obj=1)
    y = model.addVar(name="Beta", lb=0, obj=2)

    # Define constraints
    iron_constraint = model.addConstr(5 * x + 10 * y >= 50, name="Iron_Intake")
    biotin_constraint = model.addConstr(20 * x + 3 * y >= 40, name="Biotin_Intake")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal Solution:")
        print(f"Alpha: {x.varValue}")
        print(f"Beta: {y.varValue}")
        print(f"Cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_supplement_problem()
