
import gurobipy as gp

# Create a new model
model = gp.Model("Investment_Optimization")

# Create decision variables
m = model.addVar(lb=0, name="Milk_Investment")
c = model.addVar(lb=0, name="Cheese_Investment")

# Set objective function
model.setObjective(0.08 * m + 0.06 * c, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(m + c <= 30000, "Total_Investment")
model.addConstr(m >= 3 * c, "Milk_Investment_Ratio")
model.addConstr(m <= 25000, "Milk_Investment_Limit")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal investment in Milk: ${m.x:.2f}")
    print(f"Optimal investment in Cheese: ${c.x:.2f}")
    print(f"Maximum earnings: ${model.objVal:.2f}")
else:
    print("No solution found.")

