
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Add variables
x_m = m.addVar(vtype=GRB.CONTINUOUS, name="milk_investment")
x_c = m.addVar(vtype=GRB.CONTINUOUS, name="cheese_investment")

# Set the objective function
m.setObjective(0.08*x_m + 0.06*x_c, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x_m + x_c == 30000, "total_investment")
m.addConstr(x_m >= 3*x_c, "milk_vs_cheese")
m.addConstr(x_m <= 25000, "max_milk_investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milk Investment: ${x_m.x}")
    print(f"Cheese Investment: ${x_c.x}")
    print(f"Maximum Earnings: ${0.08*x_m.x + 0.06*x_c.x}")
else:
    print("No optimal solution found")

