
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    M = model.addVar(lb=0, name="Milk_Investment")
    C = model.addVar(lb=0, name="Cheese_Investment")

    # Objective: Maximize earnings
    model.setObjective(0.08 * M + 0.06 * C, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(M + C <= 30000, name="Total_Investment")
    model.addConstr(M >= 3 * C, name="Milk_Cheese_Ratio")
    model.addConstr(M <= 25000, name="Milk_Investment_Limit")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal investment in milk industry: ${M.varValue}")
        print(f"Optimal investment in cheese industry: ${C.varValue}")
        print(f"Maximized earnings: ${0.08 * M.varValue + 0.06 * C.varValue}")
    else:
        print("The problem is infeasible.")

solve_investment_problem()
