
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("protein_bars")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # Protein Bar A
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # Protein Bar B


# Set objective function
m.setObjective(7*x + 10*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x + 15*y >= 80, "protein")
m.addConstr(3*x + 5*y >= 50, "fat")
m.addConstr(11*x + 8*y >= 100, "carbs")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal:.2f}")
    print(f"Buy {x.x:.2f} of Protein Bar A")
    print(f"Buy {y.x:.2f} of Protein Bar B")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status {m.status}")

