
from gurobipy import *

# Create a new model
m = Model("Protein_Bars")

# Define the variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="Protein_Bar_A")
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="Protein_Bar_B")

# Define the constraints
m.addConstr(10*x + 15*y >= 80, name="Protein_Requirement")
m.addConstr(3*x + 5*y >= 50, name="Fat_Requirement")
m.addConstr(11*x + 8*y >= 100, name="Carbs_Requirement")

# Define the objective function
m.setObjective(7*x + 10*y, GRB.MINIMIZE)

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Buy {x.x} Protein Bar A(s)")
    print(f"Buy {y.x} Protein Bar B(s)")
    print(f"Total cost: ${7*x.x + 10*y.x}")
else:
    print("No optimal solution found")
