
import gurobi

def solve_protein_bar_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="Protein_Bar_A", vtype=gurobi.GRB.INTEGER, lb=0)
    y = model.addVar(name="Protein_Bar_B", vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function: minimize cost
    model.setObjective(7*x + 10*y, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10*x + 15*y >= 80, name="protein_requirement")
    model.addConstr(3*x + 5*y >= 50, name="fat_requirement")
    model.addConstr(11*x + 8*y >= 100, name="carbs_requirement")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal cost: ${model.objval}")
        print(f"Buy {x.varValue} of Protein Bar A and {y.varValue} of Protein Bar B")
    else:
        print("No optimal solution found")

solve_protein_bar_problem()
