
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Tropical_Farming")

# Create decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="mangoes_acres")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="pineapples_acres")

# Set objective function
m.setObjective(400*x + 450*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_constraint")
m.addConstr(80*x + 100*y <= 18000, "nutrient_constraint")
m.addConstr(2*x + 1.5*y <= 350, "picking_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Mango Acres: {x.x}")
    print(f"Pineapple Acres: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

