
from gurobipy import *

# Create a model
m = Model("Tropical_Farmer")

# Define decision variables
M = m.addVar(vtype=GRB.CONTINUOUS, name="Mangoes", lb=0)
P = m.addVar(vtype=GRB.CONTINUOUS, name="Pineapples", lb=0)

# Set the objective function
m.setObjective(400*M + 450*P, GRB.MAXIMIZE)

# Add constraints
m.addConstr(80*M + 100*P <= 18000, "Nutrient_Budget")
m.addConstr(2*M + 1.5*P <= 350, "Picking_Time")
m.addConstr(M + P <= 200, "Land_Availability")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Mangoes: {M.x}")
    print(f"Pineapples: {P.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")

