
import gurobi

def solve_farmer_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    M = model.addVar(lb=0, name="Mangoes")
    P = model.addVar(lb=0, name="Pineapples")

    # Objective function: Maximize profit
    model.setObjective(400 * M + 450 * P, gurobi.GRB.MAXIMIZE)

    # Land constraint
    model.addConstr(M + P <= 200, name="Land_Constraint")

    # Nutrient cost constraint
    model.addConstr(80 * M + 100 * P <= 18000, name="Nutrient_Cost_Constraint")

    # Picking hours constraint
    model.addConstr(2 * M + 1.5 * P <= 350, name="Picking_Hours_Constraint")

    # Optimize the model
    model.optimize()

    # Print the status
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Acres of Mangoes: {M.varValue}")
        print(f"Acres of Pineapples: {P.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_farmer_problem()
