
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("bus_ticket_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.INTEGER, name="adult_tickets")  # Integer number of adult tickets
y = m.addVar(lb=0, vtype=GRB.INTEGER, name="child_tickets") # Integer number of child tickets

# Set objective function
m.setObjective(3*x + y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 80, "capacity")
m.addConstr(y >= 15, "min_child_tickets")
m.addConstr(x >= 3*y, "adult_child_ratio")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of adult tickets: {x.x}")
    print(f"Number of child tickets: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible. No solution exists.")
else:
    print(f"Optimization terminated with status: {m.status}")

